var stateNormal = 1;
var statePressed = 2;
var stateDisabled = 3;
var stateHidden = 4;

var typeButton = 0;
var typePlaceholder = 1;
var typeSlider = 2;
var typeInfoDisplay = 3;

var stateStopped = 0;
var statePaused = 1;
var statePlaying = 2;
var stateWaiting = 3;

function OnInitialize()
{
	if(Metamorphis.LoadSkinState() == false)
	{
		var x = Player.Left;
		var y = Player.Top;
		
		Vol.SetWindowPos(x - 0, y + 53);
		Vol.ShowWindow(true);
		
		var ButtonVol = Player.GetSkinItem(typeButton, "ToggleVol");
		ButtonVol.State = statePressed;
		ButtonVol.Tooltip = "Hide Volume / Position";
		
		EQ.SetWindowPos(x + 230, y);
		EQ.ShowWindow(true);
		
		var ButtonEQ = Player.GetSkinItem(typeButton, "ToggleEqualizer");
		ButtonEQ.State = statePressed;
		ButtonEQ.Tooltip = "Hide Equalizer";
		
		Visualization.SetWindowPos(x - 200, y + 0);
		Visualization.ShowWindow(true);
		
		var ButtonVis = Player.GetSkinItem(typeButton, "ToggleVisualization");
		ButtonVis.State = statePressed;
		ButtonVis.Tooltip = "Hide Visualization";
		
		Playlist.SetWindowPos(x - 0, y +85);
		Playlist.ShowWindow(true);
		
		var ButtonPl = Player.GetSkinItem(typeButton, "TogglePlaylist");
		ButtonPl.State = statePressed;
		ButtonPl.Tooltip = "Hide Playlist";
	}
	
	
	OnPlayStateChanged();
}


function OnExit()
{
	Metamorphis.SaveSkinState();
}

function OnToggleVolButton()
{   	
	var Button = Player.GetSkinItem(typeButton, "ToggleVol");
	if(Vol.IsWindowVisible() == false)
	{
		Vol.ShowWindow(true);
		Vol.MoveWindowAnimated(0, 27, 1);
		
		if(Playlist.IsWindowVisible() == true) 
			Playlist.MoveWindowAnimated(0, 27, 1);
			
		Button.State = statePressed;
		Button.Tooltip = "Hide Volume / Position";
	} 
	else
	{
		Vol.MoveWindowAnimated(0, -27, 1);
		Vol.ShowWindow(false);
		
		if(Playlist.IsWindowVisible() == true)
			Playlist.MoveWindowAnimated(0, -27, 1);	
			
		Button.State = stateNormal;
		Button.Tooltip = "Show Volume / Position";			
	}
}

function OnToggleEqButton()
{	
	var Button = Player.GetSkinItem(typeButton, "ToggleEqualizer");
	if(EQ.IsWindowVisible())
	{
		EQ.MoveWindowAnimated( -115, 0, 1);
		EQ.ShowWindow(false);
		
		Button.State = stateNormal;
		Button.Tooltip = "Show Equalizer";	
	}
	else
	{
		EQ.ShowWindow(true);
		EQ.MoveWindowAnimated(115,  0, 1);
		
		Button.State = statePressed;
		Button.Tooltip = "Hide Equalizer";	
	}
}

function OnToggleVisualization()
{		
	var Button = Player.GetSkinItem(typeButton, "ToggleVisualization");
	if(Visualization.IsWindowVisible())
	{
		Visualization.ShowWindow(false);
	
		Button.State = stateNormal;
		Button.Tooltip = "Show Visualization";	
	}
	else
	{	
		Visualization.ShowWindow(true);
	
		Button.State = statePressed;
		Button.Tooltip = "Hide Visualization";	
	}
}

function OnTogglePlaylist()
{		
	var x = Vol.Left;
	var y = Vol.Top + Vol.Height;
	
	Playlist.SetWindowPos(x, y);

	var Button = Player.GetSkinItem(typeButton, "TogglePlaylist");
	if(Playlist.IsWindowVisible())
	{
		Playlist.ShowWindow(false);
		
		Button.State = stateNormal;
		Button.Tooltip = "Show Playlist";	
	}
	else
	{	
		Playlist.ShowWindow(true);
		
		Button.State = statePressed;
		Button.Tooltip = "Show Playlist";	
	}
}

function OnPlayStateChanged()
{
	var PlayState = MJAutomation.GetPlayback().State;

	if(PlayState == statePlaying)
	{
		Visualization.GetSkinItem(typePlaceholder, "LogoAnimated").State = stateHidden;
		Visualization.GetSkinItem(typePlaceholder, "Visualization").State = stateNormal;
	}
	else if(PlayState == stateStopped)
	{
		Visualization.GetSkinItem(typePlaceholder, "LogoAnimated").State = stateNormal;
		Visualization.GetSkinItem(typePlaceholder, "Visualization").State = stateHidden;
	}
}

